unit TTreeNodesDelete;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Dialogs,
  Menus, Controls, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TV: TTreeView;
    CheckBox1: TCheckBox;
    procedure TVMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TTreeNodesDelete
// Property: ComCtrls.TCustomTreeView.Items
// Method: ComCtrls.TTreeNodes.Delete

// BeginCode
{
The following example deletes an item in the tree view when
the user clicks on it, and if the checkbox is checked. This example
requires a populated TreeView.
} 
procedure TForm1.TVMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  HT : THitTests;
begin
if (CheckBox1.Checked) and (Sender is TTreeView) then
  begin
  with Sender as TTreeView do 
    begin
    HT := GetHitTestInfoAt(X,Y);
    if (htOnItem in HT) then
      Items.Delete(GetNodeAt(X,Y));
    end;
  end;
end;
// EndCode
// EndExample: TTreeNodesDelete
end.

