unit TUpDownOnClick;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    UpDown1: TUpDown;
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TUpDownOnClick
// Method: Forms.TCustomForm.OnCreate
// Event: ComCtrls.TCustomUpDown.OnClick
// Method: ComCtrls.TPageControl.SelectNextPage

// Warning: SelectNextPage wraps going up but not going down?

// BeginCode
{
This example requires a new TPageControl, as-is, with no new pages
created at design time, and a TUpDown control, also from the Win95
page of the component palette.  The form OnCreate event handler
adds several new TabSheet controls to the Page Control.  The 
UpDown1Click event handler fires when the user clicks the up or
down button on the TUpDown control.  The SelectNextPage method of
the Page Control goes forward the comparison (Button = btNext)
evaluates as true.  If Button is not btNext, the previous Tab Page
is selected.
}
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
const
  colorPalette: Array[0..11] of TColor =
    (clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
    clTeal, clNavy, clMaroon, clLime, clOlive, clPurple);
begin
  for i := 0 to 9 do
    with TTabSheet.Create(Self) do
    begin
      PageControl := PageControl1;
      Caption := 'TabSheet #' + IntToStr(i);
      Brush.Color := colorPalette[i];
    end;
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
  PageControl1.SelectNextPage(Button = btNext);
end;
// EndCode
// EndExample: TUpDownOnClick
end.
