{
OnCustomDraw, Canvas, Bitmap, StretchDraw example
The following example is taken from the custom draw demo. It shows how the OnCustomDraw event handler draws the background for the tree view before the items and lines are drawn.
} 
procedure TCustomDrawForm.TVCustomDraw(Sender: TCustomTreeView; const ARect: TRect; var DefaultDraw: Boolean);
begin
//This event should be used to draw any background colors or images.
//ARect represents the entire client area of the TreeView.
//Use the TreeView's canvas to do the drawing.
//Note that drawing a background bitmap is not really supported by CustomDraw,
//so scrolling can get messy. Best to subclass the TreeView and handle scrolling
//messages.
  with TV.Canvas do
  begin
    if None1.Checked then //no picture
    begin
      Brush.Color := BkgColorDialog.Color;
      Brush.Style := FBrushStyle;
      FillRect(ARect);
    end else
      if Tile1.Checked then //tile bitmap
      begin
        Brush.Bitmap := Image1.Picture.Bitmap;
          FillRect(ARect);
        end else //Stretch across the canvas.
            StretchDraw(ARect, Image1.Picture.Bitmap);
  end;
  DefaultDraw := FDefaultDraw;
  //setting DefaultDraw to false here prevents all calls to OnCustomDrawItem.
end; 
