{
OnCustomDrawItem, DisplayRect, Level, Indent example
The following example shows how the OnCustomDrawItem event handler draws items and lines of the tree view after the OnCustomDraw event handler has filled in the background.
} 
procedure TCustomDrawForm.TVCustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  NodeRect: TRect;
begin
  with TV.Canvas do
  begin
    //If DefaultDraw it is true, any of the node's font properties can be
    //changed. Note also that when DefaultDraw = True, Windows draws the
    //buttons and ignores our font background colors, using instead the
    //TreeView's Color property.
    if cdsSelected in State then
    begin
      Font.Assign(SelectedFontDialog.Font);
      Brush.Color := SelBkgColorDialog.Color;
    end;
    DefaultDraw := FDefaultDrawItem;
    //DefaultDraw = False means you have to handle all the item drawing yourself,
    //including the buttons, lines, images, and text.
    if not DefaultDraw then
    begin
      //draw the selection rect.
      if cdsSelected in State then
      begin
        NodeRect := Node.DisplayRect(True);
        FillRect(NodeRect);
      end;
      NodeRect := Node.DisplayRect(False);
      if None1.Checked then
      //no bitmap, so paint in the background color.
      begin
        Brush.Color := BkgColorDialog.Color;
        Brush.Style := FBrushStyle;
        FillRect(NodeRect)
      end
      else
        //don't paint over the background bitmap.
        Brush.Style := bsClear;
      NodeRect.Left := NodeRect.Left + (Node.Level * TV.Indent);
      //NodeRect.Left now represents the left-most portion of the expand button
      DrawButton(NodeRect, Node);
      NodeRect.Left := NodeRect.Left + TV.Indent + FButtonSize;
      //NodeRect.Left is now the leftmost portion of the image.
      DrawImage(NodeRect, Node.ImageIndex);
      NodeRect.Left := NodeRect.Left + ImageList.Width;
      //Now we are finally in a position to draw the text.
      TextOut(NodeRect.Left, NodeRect.Top, Node.Text);
    end;
  end;
end; 
