unit TabControlChange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TabControl1: TTabControl;
    Memo1: TMemo;
    Add_a_file: TButton;
    OpenDialog1: TOpenDialog;
    Assign_files: TButton;
    procedure Add_a_fileClick(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure Assign_filesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TabControlChange
// Property: ComCtrls.TCustomTabControl.Tabs
// Property: ComCtrls.TCustomTabControl.TabIndex
// Property: ComCtrls.TCustomTabControl.OnChange
// Method: Classes.TStrings.Assign
// Property: Classes.TStrings.Add
// Property: Dialogs.TOpenDialog.FileName
// Property: Dialogs.TOpenDialog.Files

// BeginCode
{
This example uses a tab control to display the contents of
several files. To run the example, place a tab control on a
form and add a memo control that fits into its client area.
Be sure to leave enough room for the tabs when they appear.
Then add an OpenDialog and a button to the form.  The
"Add a file" button adds a single file to the tabcontrol.
The "Assign files" button removes previous files and can be
used to assign multiple files.  To assign multiple files,
use CNTL Select or SHIFT Select to select files in the
OpenDialog.
}
procedure TForm1.Add_a_fileClick(Sender: TObject);
var index : integer;
begin
  OpenDialog1.Options :=
    [ofAllowMultiSelect, ofFileMustExist, ofHideReadOnly];
  if OpenDialog1.Execute then
  begin
    index:= TabControl1.Tabs.Add(OpenDialog1.FileName);
    Memo1.Lines.LoadFromFile(TabControl1.Tabs[index]);
    TabControl1Change(Sender);
  end;
end;

procedure TForm1.Assign_filesClick(Sender: TObject);
var index : integer;
begin
  OpenDialog1.Options :=
    [ofAllowMultiSelect, ofFileMustExist, ofHideReadOnly];
  if OpenDialog1.Execute then
  begin
    TabControl1.Tabs.Assign(OpenDialog1.Files);
    Memo1.Lines.LoadFromFile(
      TabControl1.Tabs[TabControl1.TabIndex]);
  end;
end;

{
Place the following code in the tab controls OnChange event
handler:
}
procedure TForm1.TabControl1Change(Sender: TObject);
begin
  with TabControl1 do
    Memo1.Lines.LoadFromFile(Tabs[TabIndex]);
end;
// EndCode
// EndExample: TabControlChange
end.
