{
Tabs, TabIndex, OnChange, Assign example
This example uses a tab control to display the contents of several files. To run the example, place a tab control on a form and add a memo control that fits into its client area. Be sure to leave enough room for the tabs when they appear. Then add an OpenDialog and a button to the form.
The "Add a file" button
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenDialog1.Options := [ofAllowMultiSelect, ofFileMustExist, ofHideReadOnly ];
  if OpenDialog1.Execute then
  begin
    TabControl1.Tabs.Assign(OpenDialog1.Files);
    Memo1.Lines.LoadFromFile(TabContol1.Tabs[TabControl1.TabIndex]);
  end;
end;
On Cross-platform:
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  with OpenDialog1 do
  begin
    Options := [ofAllowMultiSelect, ofFileMustExist];
    if Execute then
    begin
      TabControl1.Tabs.Clear;
      for I := 0 to Files.Count - 1 do
        TabControl1.Tabs.Add(Files[I]);
    end;
    TabControl1Change(Sender);
  end;
end;
Place the following code in the tab controls OnChange event handler:
*) 
procedure TForm1.TabControl1Change(Sender: TObject);
begin
  with TabControl1 do
    Memo1.Lines.LoadFromFile(Tabs[TabIndex].Caption);
end; 
