unit TabSheetPageControl;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    procedure PageControl1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TabSheetPageControl
// Property: ComCtrls.TTabSheet.PageControl
// Method: ComCtrls.TPageControl.FindNextPage
// Event: ComCtrls.TCustomTabControl.OnChange
// Class: ComCtrls.TPageControl

// BeginCode
{
This example requires a new TPageControl, with no new pages
created at design time.  The form OnCreate event handler
adds several new TabSheet controls to the Page Control.  The
Page Controls OnChange event handler displays a message
dialog when the user changes tabs.  The message dialog
contains the captions for the tabs immediately before and
after the active tab.
}
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to 9 do
    with TTabSheet.Create(Self) do
    begin
      PageControl := PageControl1;
      Caption := 'TabSheet #' + IntToStr(i);
    end;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
var
  PrevCaption, NextCaption: ShortString;
begin
  with (Sender as TPageControl) do
  begin
    PrevCaption :=
      FindNextPage(ActivePage, False, False).Caption;
    NextCaption :=
      FindNextPage(ActivePage, True, False).Caption;
  end;
  ShowMessage('Previous tab caption: "' + PrevCaption +
    '"    Next tab Caption: "' + NextCaption + '"');
end;
// EndCode
// EndExample: TabSheetPageControl
end.
