{
PageControl, FindNextPage, OnChange example
This example requires a new TPageControl, with no new pages created at design time.  
The form OnCreate event handler adds several new TabSheet controls to the Page Control.  The Page Controls OnChange event handler displays a message dialog when the user changes tabs.  The message dialog contains the captions for the tabs immediately before and after the active tab.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to 9 do
    with TTabSheet.Create(Self) do
    begin
      PageControl := PageControl1;
      Caption := 'TabSheet #' + IntToStr(i);
    end;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
var
  PrevCaption, NextCaption: ShortString;
begin
  with (Sender as TPageControl) do
  begin
    PrevCaption := FindNextPage(ActivePage, True, False).Caption;
    NextCaption := FindNextPage(ActivePage, False, False).Caption;
  end;
  ShowMessage('Previous tab caption: "' + PrevCaption +
    '"    Next tab Caption: "' + NextCaption + '"');
end;
 
