unit TabVisible;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TabVisible
// Property: ComCtrls.TTabSheet.PageIndex
// Property: ComCtrls.TTabSheet.TabIndex
// Property: ComCtrls.TTabSheet.TabVisible
// Method: ComCtrls.TTabSheet.Create

// BeginCode
{
This example creates ten Tab Sheets and sets the captions to
display PageIndex and TabIndex for each tab.  Odd numbered
tabs have their TabVisible property set off to demonstrate
the effect on PageIndex vs TabIndex.  On the series of
visible tabs, PageIndex will read 0, 2, 4, 6, 8, and
TabIndex will read 0, 1, 2, 3, 4.  PageIndex counts only
visible tabs.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
const
  colorpalette: Array[0..11] of TColor = (
    clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
    clTeal, clNavy, clMaroon, clLime, clOlive, clPurple);
begin
  with PageControl1 do
    for i := 0 to 9 do
      with TTabSheet.Create(Self) do
      begin
        PageControl := PageControl1;
        TabVisible := (PageIndex mod 2 = 0);
        Brush.Color := colorpalette[i];
        Caption := 'PageIndex: ' +
        IntToStr(PageIndex) + '  TabIndex: ' +
          IntToStr(TabIndex);
      end;
end;
// EndCode
// EndExample: TabVisible
end.
