{
PageIndex, TabIndex, TabVisible example
This example creates ten Tab Sheets and sets the captions to display PageIndex and TabIndex for each tab.  Odd numbered tabs have their TabVisible property set off to demonstrate the effect on PageIndex vs TabIndex.  On the series of visible tabs, PageIndex will read 0, 2, 4, 6, 8, and TabIndex will read 0, 1, 2, 3, 4.  PageIndex counts only visible tabs.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  with PageControl1 do
    for i := 0 to 9 do
      with TTabSheet.Create(Self) do
      begin
        PageControl := PageControl1;
        TabVisible := (PageIndex mod 2 = 0);
        Caption := 'PageIndex: ' +
        IntToStr(PageIndex) + '  TabIndex: ' +
          IntToStr(TabIndex);
      end;
end;
 
