unit ThreadSynchronize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, EnumeratorThread;

type
  TForm2 = class(TForm)
    Memo1: TMemo;
    btStop: TButton;
    btStart: TButton;
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
  private
    { Private declarations }
    FThread : TEnumeratorThread;
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.btStartClick(Sender: TObject);
begin
  { Disable Start button }
  btStart.Enabled := false;

  { Create a new thread and start it }
  FThread := TEnumeratorThread.Create(Memo1);
  FThread.Resume;

  { Enable stop button }
  btStop.Enabled := true;
end;

procedure TForm2.btStopClick(Sender: TObject);
begin
  { Disable Stop button }
  btStop.Enabled := false;

  { Wait for the thread to finish executing and free it }
  FThread.GentleStop;
  FThread.Free;

  { Enable start button }
  btStart.Enabled := true;
end;

end.
