unit TreeNodeAddChildObject;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ImgList;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Button1: TButton;
    ImageList: TImageList;
    procedure Button1Click(Sender: TObject);
    procedure TreeView1CustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
      State: TCustomDrawState; var DefaultDraw: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TreeNodeAddChildObject
// Method: ComCtrls.TTreeNodes.AddChildObject

// BeginCode
{
The following example adds a new child to the selected
items list of child items in the tree view control. The new
item is identified by the text New Item. The TBitmap
object is attached to the new item.
}
procedure TForm1.Button1Click(Sender: TObject);
var MyBitMap : TBitmap;
begin
  MyBitMap := TBitmap.Create;
  MyBitMap.LoadFromFile('littleB16.bmp');
  TreeView1.Items.BeginUpdate;  // keep the node from painting until it's built
  TreeView1.Items.AddChildObject(
    TreeView1.Selected, 'New Item', MyBitMap);
  TreeView1.Items.EndUpdate;
end;
// EndCode
// EndExample: TreeNodeAddChildObject

procedure TForm1.TreeView1CustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  bitmap : TBitmap;
  NodeRect : TRect;
begin
  DefaultDraw := (Node.Data = nil);
//  DefaultDraw = True;
  if (not DefaultDraw) then
  begin
	  bitmap := TBitmap(Node.Data);
	  NodeRect := Node.DisplayRect(True);
	  TreeView1.Canvas.FillRect(NodeRect);
	  TreeView1.Canvas.Draw(NodeRect.Left, NodeRect.Top, bitmap);
	  NodeRect.Left := NodeRect.Left + bitmap.Width;
	  TreeView1.Canvas.TextOut(NodeRect.Left, NodeRect.Top, Node.Text);
  end;
end;

end.
