{
CustomSort example
This example shows how to use the CustomSort method to order a subtree in case-insensitive alphabetical order (either forward or backward). The callback function CompareFunc below calls the global AnsiStrIComp function to perform the actual comparison.
} 
function CustomSortProc(Node1, Node2: TTreeNode; Data: Longint): Integer; stdcall;
begin
  if Data = 0 then
    Result := AnsiStrIComp(Pchar(Node1.Text), PChar(Node2.Text));
  else
    Result := -AnsiStrIComp(PChar(Node1.Text), PChar(Node2.Text));
end;
This procedure can then be used as a parameter to CustomSort to sort the children of a node:
TreeNode1.CustomSort(@CustomSortProc, 0);  { Sorts in ascending order }
TreeNode1.CustomSort(@CustomSortProc, 1);  { Sorts in descending order }
 
