{
AddObject, Count, Data example
The following code defines a record type of TMyRec and a record pointer type of PMyRec.
} 
type
PMyRec = ^TMyRec;
TMyRec = record
  FName: string;
  LName: string;
end;
Assuming these types are used, the following code adds a node to TreeView1 as the last sibling of a specified node. A TMyRec record is associated with the added item. The FName and LName fields are obtained from edit boxes Edit1 and Edit2. The Index parameter is obtained from edit box Edit3. The item is added only if the Index is a valid value.
*) 
procedure TForm1.Button1Click(Sender: TObject);
var
  MyRecPtr: PMyRec;
  TreeViewIndex: LongInt;
begin
  New(MyRecPtr);
  MyRecPtr^.FName := Edit1.Text;
  MyRecPtr^.LName := Edit2.Text;
  TreeViewIndex := StrToInt(Edit3.Text);
  with TreeView1 do
  begin
    if Items.Count = 0 then
      Items.AddObject(nil, 'Item' + IntToStr(TreeViewIndex), MyRecPtr)
    else if (TreeViewIndex < Items.Count) and (TreeViewIndex >= 0) then
      Items.AddObject(Items[TreeViewIndex], 'Item' + IntToStr(TreeViewIndex), MyRecPtr);
  end;
end;
After an item containing a TMyRec record has been added, the following code retrieves the FName and LName values associated with the item and displays the values in a label.
*) 
procedure TForm1.Button2Click(Sender: TObject);
begin
  Label1.Caption := PMyRec(TreeView1.Selected.Data)^.FName + ' ' +
                  PMyRec(TreeView1.Selected.Data)^.LName;
end; 
