unit UsingGUIDs;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm2 = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: UsingGUIDs
// Routine: SysUtils.StringToGUID
// Routine: SysUtils.GUIDToString
// Routine: SysUtils.CreateGUID
// Routine: SysUtils.IsEqualGUID
// Type: System.TGUID
// Type: System.PGUID

// BeginCode
{
This example demonstrates the usage of some GUID related routines along with
the type itself.
}
procedure TForm2.FormCreate(Sender: TObject);
var
  MyGuid0, MyGuid1 : TGUID;

begin
  { Create a new GUID from the string representation }
  MyGuid0 := StringToGUID('{00020400-0000-0000-C000-000000000046}');
  Memo1.Lines.Add('The GUID is: ' + GUIDToString(MyGuid0));

  {
  Accessing GUID's internal fields. Using Format function to obtain the
  same output as GUIDToString
  }
  Memo1.Lines.Add(Format('GUID using formatting is: ' +
       '{%0.8X-%0.4X-%0.4X-%0.2X%0.2X-%0.2X%0.2X%0.2X%0.2X%0.2X%0.2X}',
       [MyGuid0.D1, MyGuid0.D2, MyGuid0.D3,
       MyGuid0.D4[0], MyGuid0.D4[1], MyGuid0.D4[2], MyGuid0.D4[3],
       MyGuid0.D4[4], MyGuid0.D4[5], MyGuid0.D4[6], MyGuid0.D4[7]]));

  { Auto-generate a random GUID at runtime }
  if CreateGUID(MyGuid1) <> 0 then
     Memo1.Lines.Add('Creating GUID failed!')
  else
     Memo1.Lines.Add('The generated guid is: ' + GUIDToString(MyGuid1));

  { Generating second random GUID }
  CreateGUID(MyGuid0);

  { Testing if 2 guids are equal }
  if IsEqualGUID(MyGuid0, MyGuid1) then
     Memo1.Lines.Add('This cannot happen! CreateGUID guarantees that ' +
                     '2 randomly generated GUIDs cannot be equal!');
end;
// EndCode
// EndExample: UsingGUIDs

end.
