unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: VariantArrays
// Routine: Variants.VarArrayCreate
// Routine: Variants.VarArrayDimCount
// Routine: Variants.VarArrayLowBound
// Routine: Variants.VarArrayHighBound
// Routine: Variants.VarArrayPut
// Routine: Variants.VarArrayGet
// Routine: System.VarArrayRedim
// BeginCode
{
This example demonstrates the use of variant arrays. In this
example a variant array is created, modified, populated and then freed.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  Arr: Variant;
  I: Integer;
begin
  { Create a variant array of 10 elements, starting at 0
    and ending at 9. The array contains elements of type integer }
  Arr := VarArrayCreate([0, 9], varInteger);

  { Increase the length of the variant array }
  VarArrayRedim(Arr, 49);

  MessageDlg('Variant array has ' + IntToStr(VarArrayDimCount(Arr)) + ' dimensions',
      mtInformation, [mbOK], 0);

  { Traverse the array from lower to higher bounds }
  for I := VarArrayLowBound(Arr, 1) to VarArrayHighBound(Arr, 1) do
  begin
    { Put the element I at index I}
    VarArrayPut(Arr, I, [I]);
  end;

  { Now read the elements of the array }
  for I := VarArrayLowBound(Arr, 1) to VarArrayHighBound(Arr, 1) do
  begin
    { Put the element I at index I}
    if VarArrayGet(Arr, [I]) <> I then
      MessageDlg('Error! Invalid element found at current position!', mtError, [mbOK], 0);
  end;

  { Clear the variant array }
  VarClear(Arr);
end;
// EndCode
// EndExample: VariantArrays

end.
