unit VertScrollBar;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: VertScrollBar
// Property: Forms.TScrollingWinControl.VertScrollBar
// Property: Forms.TControlScrollBar.Increment
// Property: Forms.TControlScrollBar.Position
// Property: Forms.TControlScrollBar.Range
// Property: Forms.TControlScrollBar.Visible
// Property: Controls.TControl.ClientHeight
// BeginCode
{
The following example demonstrates form scrolling with the
PgUp and PgDn keys.
}
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
Shift: TShiftState);
const
  PageDelta = 10;
begin
  With VertScrollbar do
    if Key = VK_NEXT then
      Position := Position + PageDelta
    else if Key = VK_PRIOR then
      Position := Position - PageDelta;
end;
// EndCode
// EndExample: VertScrollBar

procedure TForm1.FormCreate(Sender: TObject);
begin
  ClientHeight := 300;
  with VertScrollBar do
  begin
    { Set the range to twice the ClientWidth of the form }
    { This means that the forms logical size is twice as big }
    { as the physical window. }
    { Note that Range must always be larger than the ClientWidth }
    Range := 600;
    Position := Range - ClientHeight; { start form out fully scrolled }
    Visible := True;  { Show the scrollbar }
  end;
end; 

end.
