unit ComboBoxEx;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ImgList;

type
  TForm3 = class(TForm)
    Button1: TButton;
    ComboBoxEx1: TComboBoxEx;
    ImageList1: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    combEx : TComboBoxEx;
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: TComboBoxEx
// Class: ComCtrls.TComboBoxEx
// Class: ComCtrls.TComboExItems
// Method: ComCtrls.TComboExItems.AddItem

// BeginCode
{
This is a very simple example showing how to create a comboBoxEx, add
to it some items and images, indenting the items and getting the
selected value.
}
procedure TForm3.Button1Click(Sender: TObject);
begin
  MessageDlg('Selected text: ' + combEx.Text,
  			 mtInformation, mbYesNo, 0);

end;

procedure TForm3.FormCreate(Sender: TObject);
var
  myImages : TImageList;
  image : TBitmap;
begin
  //comboBoxEx initialization
  combEx := TComboBoxEx.Create(Self);
  combEx.Parent := Self;

  //visual options
  combEx.Align := alLeft;
  combEx.DoubleBuffered := true;

  //initializing the TBitmap
  image := TBitmap.Create();

  //adding image content
  myImages := TImageList.CreateSize(64, 64);
  image.LoadFromFile('little_logo_64.bmp');
  myImages.Add(image,nil);
  image.LoadFromFile('littleB_64.bmp');
  myImages.Add(image,nil);
  image.LoadFromFile('little_sun_64.bmp');
  myImages.Add(image,nil);

  combEx.Images := myImages;

  //adding the items with the corresponding indexes to the images
  //plus some indentations

  combEx.ItemsEx.AddItem('firstChoiceEx', 0, 0, 0, 0, nil);
  combEx.ItemsEx.AddItem('secondChoiceEx', 1, 1, 1, 1, nil);
  combEx.ItemsEx.AddItem('thirdChoiceEx', 2, 2, 2, 2, nil);
  ComboBoxEx1.ItemsEx.AddItem('firstChoiceEx', 0, 0, 0, 0, nil);
  ComboBoxEx1.ItemsEx.AddItem('secondChoiceEx', 1, 1, 1, 1, nil);
  ComboBoxEx1.ItemsEx.AddItem('thirdChoiceEx', 2, 2, 2, 2, nil);

   //setting the default value
  combEx.ItemIndex := 1;
  ComboBoxEx1.ItemIndex := 0;

end;
// EndCode
// EndExample: TComboBoxEx
end.
