#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

# Character ranges of letters
letters = 'a-zA-Z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u0103\u0106\u0107\
\u010c-\u010f\u0112-\u0115\u011a-\u012d\u0131\u0141\u0142\u0147\u0148\
\u0150-\u0153\u0158-\u0161\u0164\u0165\u016e-\u0171\u017d\u017e\
\u0391-\u03a1\u03a3-\u03a9\u03b1-\u03c9\u03d1\u03d2\u03d5\u03d6\
\u03da-\u03e1\u03f0\u03f1\u03f5\u210a-\u210c\u2110-\u2113\u211b\u211c\
\u2128\u212c\u212d\u212f-\u2131\u2133-\u2138\uf6b2-\uf6b5\uf6b7\uf6b9\
\uf6ba-\uf6bc\uf6be\uf6bf\uf6c1-\uf700\uf730\uf731\uf770\uf772\uf773\
\uf776\uf779\uf77a\uf77d-\uf780\uf782-\uf78b\uf78d-\uf78f\uf790\
\uf793-\uf79a\uf79c-\uf7a2\uf7a4-\uf7bd\uf800-\uf833\ufb01\ufb02'

# Character ranges of letterlikes
letterlikes = '\u0024\u00A1\u00A2\u00A3\u00A5\u00A7\u00A9\u00AB\u00AE\
\u00B0\u00B5\u00B6\u00B8\u00BB\u00BF\u02C7\u02D8\u2013\u2014\u2020\u2021\
\u2022\u2026\u2032\u2033\u2035\u2036\u2060\u20AC\u210F\u2122\u2127\u212B\
\u21B5\u2205\u221E\u221F\u2220\u2221\u2222\u22EE\u22EF\u22F0\u22F1\u2300\
\u2318\u231A\u23B4\u23B5\u2500\u2502\u25A0\u25A1\u25AA\u25AE\u25AF\u25B2\
\u25B3\u25BC\u25BD\u25C0\u25C6\u25C7\u25CB\u25CF\u25E6\u25FB\u25FC\u2605\
\u2639\u263A\u2660\u2661\u2662\u2663\u266D\u266E\u266F\u2736\uF3A0\uF3B8\
\uF3B9\uF527\uF528\uF720\uF721\uF722\uF723\uF725\uF749\uF74A\uF74D\uF74E\
\uF74F\uF750\uF751\uF752\uF753\uF754\uF755\uF756\uF757\uF760\uF763\uF766\
\uF768\uF769\uF76A\uF76B\uF76C\uF7D4\uF800\uF801\uF802\uF803\uF804\uF805\
\uF806\uF807\uF808\uF809\uF80A\uF80B\uF80C\uF80D\uF80E\uF80F\uF810\uF811\
\uF812\uF813\uF814\uF815\uF816\uF817\uF818\uF819\uF81A\uF81B\uF81C\uF81D\
\uF81E\uF81F\uF820\uF821\uF822\uF823\uF824\uF825\uF826\uF827\uF828\uF829\
\uF82A\uF82B\uF82C\uF82D\uF82E\uF82F\uF830\uF831\uF832\uF833\uFE35\uFE36\
\uFE37\uFE38'

# All supported longname characters
named_characters = {
    'AAcute': '\u00E1',
    'ABar': '\u0101',
    'ACup': '\u0103',
    'ADoubleDot': '\u00E4',
    'AE': '\u00E6',
    'AGrave': '\u00E0',
    'AHat': '\u00E2',
    'Aleph': '\u2135',
    'AliasDelimiter': '\uF764',
    'AliasIndicator': '\uF768',
    'AlignmentMarker': '\uF760',
    'Alpha': '\u03B1',
    'AltKey': '\uF7D1',
    'And': '\u2227',
    'Angle': '\u2220',
    'Angstrom': '\u212B',
    'ARing': '\u00E5',
    'AscendingEllipsis': '\u22F0',
    'ATilde': '\u00E3',
    'AutoLeftMatch': '\uF3A8',
    'AutoOperand': '\uF3AE',
    'AutoPlaceholder': '\uF3A4',
    'AutoRightMatch': '\uF3A9',
    'AutoSpace': '\uF3AD',
    'Backslash': '\u2216',
    'BeamedEighthNote': '\u266B',
    'BeamedSixteenthNote': '\u266C',
    'Because': '\u2235',
    'Bet': '\u2136',
    'Beta': '\u03B2',
    'BlackBishop': '\u265D',
    'BlackKing': '\u265A',
    'BlackKnight': '\u265E',
    'BlackPawn': '\u265F',
    'BlackQueen': '\u265B',
    'BlackRook': '\u265C',
    'Breve': '\u02D8',
    'Bullet': '\u2022',
    'CAcute': '\u0107',
    'CapitalAAcute': '\u00C1',
    'CapitalABar': '\u0100',
    'CapitalACup': '\u0102',
    'CapitalADoubleDot': '\u00C4',
    'CapitalAE': '\u00C6',
    'CapitalAGrave': '\u00C0',
    'CapitalAHat': '\u00C2',
    'CapitalAlpha': '\u0391',
    'CapitalARing': '\u00C5',
    'CapitalATilde': '\u00C3',
    'CapitalBeta': '\u0392',
    'CapitalCAcute': '\u0106',
    'CapitalCCedilla': '\u00C7',
    'CapitalCHacek': '\u010C',
    'CapitalChi': '\u03A7',
    'CapitalDelta': '\u0394',
    'CapitalDHacek': '\u010E',
    'CapitalDifferentialD': '\uF74B',
    'CapitalDigamma': '\u03DC',
    'CapitalEAcute': '\u00C9',
    'CapitalEBar': '\u0112',
    'CapitalECup': '\u0114',
    'CapitalEDoubleDot': '\u00CB',
    'CapitalEGrave': '\u00C8',
    'CapitalEHacek': '\u011A',
    'CapitalEHat': '\u00CA',
    'CapitalEpsilon': '\u0395',
    'CapitalEta': '\u0397',
    'CapitalEth': '\u00D0',
    'CapitalGamma': '\u0393',
    'CapitalIAcute': '\u00CD',
    'CapitalICup': '\u012C',
    'CapitalIDoubleDot': '\u00CF',
    'CapitalIGrave': '\u00CC',
    'CapitalIHat': '\u00CE',
    'CapitalIota': '\u0399',
    'CapitalKappa': '\u039A',
    'CapitalKoppa': '\u03DE',
    'CapitalLambda': '\u039B',
    'CapitalLSlash': '\u0141',
    'CapitalMu': '\u039C',
    'CapitalNHacek': '\u0147',
    'CapitalNTilde': '\u00D1',
    'CapitalNu': '\u039D',
    'CapitalOAcute': '\u00D3',
    'CapitalODoubleAcute': '\u0150',
    'CapitalODoubleDot': '\u00D6',
    'CapitalOE': '\u0152',
    'CapitalOGrave': '\u00D2',
    'CapitalOHat': '\u00D4',
    'CapitalOmega': '\u03A9',
    'CapitalOmicron': '\u039F',
    'CapitalOSlash': '\u00D8',
    'CapitalOTilde': '\u00D5',
    'CapitalPhi': '\u03A6',
    'CapitalPi': '\u03A0',
    'CapitalPsi': '\u03A8',
    'CapitalRHacek': '\u0158',
    'CapitalRho': '\u03A1',
    'CapitalSampi': '\u03E0',
    'CapitalSHacek': '\u0160',
    'CapitalSigma': '\u03A3',
    'CapitalStigma': '\u03DA',
    'CapitalTau': '\u03A4',
    'CapitalTHacek': '\u0164',
    'CapitalTheta': '\u0398',
    'CapitalThorn': '\u00DE',
    'CapitalUAcute': '\u00DA',
    'CapitalUDoubleAcute': '\u0170',
    'CapitalUDoubleDot': '\u00DC',
    'CapitalUGrave': '\u00D9',
    'CapitalUHat': '\u00DB',
    'CapitalUpsilon': '\u03A5',
    'CapitalURing': '\u016E',
    'CapitalXi': '\u039E',
    'CapitalYAcute': '\u00DD',
    'CapitalZeta': '\u0396',
    'CapitalZHacek': '\u017D',
    'Cap': '\u2322',
    'CCedilla': '\u00E7',
    'Cedilla': '\u00B8',
    'CenterDot': '\u00B7',
    'CenterEllipsis': '\u22EF',
    'Cent': '\u00A2',
    'CHacek': '\u010D',
    'Checkmark': '\u2713',
    'Chi': '\u03C7',
    'CircleDot': '\u2299',
    'CircleMinus': '\u2296',
    'CirclePlus': '\u2295',
    'CircleTimes': '\u2297',
    'ClockwiseContourIntegral': '\u2232',
    'CloseCurlyDoubleQuote': '\u201D',
    'CloseCurlyQuote': '\u2019',
    'CloverLeaf': '\u2318',
    'ClubSuit': '\u2663',
    'Colon': '\u2236',
    'CommandKey': '\uF76A',
    'Congruent': '\u2261',
    'Conjugate': '\uF3C8',
    'ConjugateTranspose': '\uF3C9',
    'ConstantC': '\uF7DA',
    'Continuation': '\uF3B1',
    'ContourIntegral': '\u222E',
    'ControlKey': '\uF763',
    'Coproduct': '\u2210',
    'Copyright': '\u00A9',
    'CounterClockwiseContourIntegral': '\u2233',
    'Cross': '\uF4A0',
    'CupCap': '\u224D',
    'Cup': '\u2323',
    'CurlyCapitalUpsilon': '\u03D2',
    'CurlyEpsilon': '\u03B5',
    'CurlyKappa': '\u03F0',
    'CurlyPhi': '\u03C6',
    'CurlyPi': '\u03D6',
    'CurlyRho': '\u03F1',
    'CurlyTheta': '\u03D1',
    'Currency': '\u00A4',
    'Dagger': '\u2020',
    'Dalet': '\u2138',
    'Dash': '\u2013',
    'Degree': '\u00B0',
    'DeleteKey': '\uF7D0',
    'Del': '\u2207',
    'Delta': '\u03B4',
    'DescendingEllipsis': '\u22F1',
    'DHacek': '\u010F',
    'Diameter': '\u2300',
    'Diamond': '\u22C4',
    'DiamondSuit': '\u2662',
    'DifferenceDelta': '\u2206',
    'DifferentialD': '\uF74C',
    'Digamma': '\u03DD',
    'DiscreteRatio': '\uF4A4',
    'DiscreteShift': '\uF4A3',
    'DiscretionaryHyphen': '\u00AD',
    'DiscretionaryLineSeparator': '\uF76E',
    'DiscretionaryParagraphSeparator': '\uF76F',
    'Divide': '\u00F7',
    'DotEqual': '\u2250',
    'DotlessI': '\u0131',
    'DotlessJ': '\uF700',
    'DottedSquare': '\uF751',
    'DoubleContourIntegral': '\u222F',
    'DoubleDagger': '\u2021',
    'DoubledGamma': '\uF74A',
    'DoubleDownArrow': '\u21D3',
    'DoubledPi': '\uF749',
    'DoubleLeftArrow': '\u21D0',
    'DoubleLeftRightArrow': '\u21D4',
    'DoubleLeftTee': '\u2AE4',
    'DoubleLongLeftArrow': '\u27F8',
    'DoubleLongLeftRightArrow': '\u27FA',
    'DoubleLongRightArrow': '\u27F9',
    'DoublePrime': '\u2033',
    'DoubleRightArrow': '\u21D2',
    'DoubleRightTee': '\u22A8',
    'DoubleStruckA': '\uF6E6',
    'DoubleStruckB': '\uF6E7',
    'DoubleStruckC': '\uF6E8',
    'DoubleStruckCapitalA': '\uF7A4',
    'DoubleStruckCapitalB': '\uF7A5',
    'DoubleStruckCapitalC': '\uF7A6',
    'DoubleStruckCapitalD': '\uF7A7',
    'DoubleStruckCapitalE': '\uF7A8',
    'DoubleStruckCapitalF': '\uF7A9',
    'DoubleStruckCapitalG': '\uF7AA',
    'DoubleStruckCapitalH': '\uF7AB',
    'DoubleStruckCapitalI': '\uF7AC',
    'DoubleStruckCapitalJ': '\uF7AD',
    'DoubleStruckCapitalK': '\uF7AE',
    'DoubleStruckCapitalL': '\uF7AF',
    'DoubleStruckCapitalM': '\uF7B0',
    'DoubleStruckCapitalN': '\uF7B1',
    'DoubleStruckCapitalO': '\uF7B2',
    'DoubleStruckCapitalP': '\uF7B3',
    'DoubleStruckCapitalQ': '\uF7B4',
    'DoubleStruckCapitalR': '\uF7B5',
    'DoubleStruckCapitalS': '\uF7B6',
    'DoubleStruckCapitalT': '\uF7B7',
    'DoubleStruckCapitalU': '\uF7B8',
    'DoubleStruckCapitalV': '\uF7B9',
    'DoubleStruckCapitalW': '\uF7BA',
    'DoubleStruckCapitalX': '\uF7BB',
    'DoubleStruckCapitalY': '\uF7BC',
    'DoubleStruckCapitalZ': '\uF7BD',
    'DoubleStruckD': '\uF6E9',
    'DoubleStruckE': '\uF6EA',
    'DoubleStruckEight': '\uF7E3',
    'DoubleStruckF': '\uF6EB',
    'DoubleStruckFive': '\uF7E0',
    'DoubleStruckFour': '\uF7DF',
    'DoubleStruckG': '\uF6EC',
    'DoubleStruckH': '\uF6ED',
    'DoubleStruckI': '\uF6EE',
    'DoubleStruckJ': '\uF6EF',
    'DoubleStruckK': '\uF6F0',
    'DoubleStruckL': '\uF6F1',
    'DoubleStruckM': '\uF6F2',
    'DoubleStruckN': '\uF6F3',
    'DoubleStruckNine': '\uF7E4',
    'DoubleStruckO': '\uF6F4',
    'DoubleStruckOne': '\uF7DC',
    'DoubleStruckP': '\uF6F5',
    'DoubleStruckQ': '\uF6F6',
    'DoubleStruckR': '\uF6F7',
    'DoubleStruckS': '\uF6F8',
    'DoubleStruckSeven': '\uF7E2',
    'DoubleStruckSix': '\uF7E1',
    'DoubleStruckT': '\uF6F9',
    'DoubleStruckThree': '\uF7DE',
    'DoubleStruckTwo': '\uF7DD',
    'DoubleStruckU': '\uF6FA',
    'DoubleStruckV': '\uF6FB',
    'DoubleStruckW': '\uF6FC',
    'DoubleStruckX': '\uF6FD',
    'DoubleStruckY': '\uF6FE',
    'DoubleStruckZ': '\uF6FF',
    'DoubleStruckZero': '\uF7DB',
    'DoubleUpArrow': '\u21D1',
    'DoubleUpDownArrow': '\u21D5',
    'DoubleVerticalBar': '\u2225',
    'DownArrowBar': '\u2913',
    'DownArrow': '\u2193',
    'DownArrowUpArrow': '\u21F5',
    'DownBreve': '\uF755',
    'DownExclamation': '\u00A1',
    'DownLeftRightVector': '\u2950',
    'DownLeftTeeVector': '\u295E',
    'DownLeftVector': '\u21BD',
    'DownLeftVectorBar': '\u2956',
    'DownPointer': '\u25BE',
    'DownQuestion': '\u00BF',
    'DownRightTeeVector': '\u295F',
    'DownRightVector': '\u21C1',
    'DownRightVectorBar': '\u2957',
    'DownTeeArrow': '\u21A7',
    'DownTee': '\u22A4',
    'EAcute': '\u00E9',
    'Earth': '\u2641',
    'EBar': '\u0113',
    'ECup': '\u0115',
    'EDoubleDot': '\u00EB',
    'EGrave': '\u00E8',
    'EHacek': '\u011B',
    'EHat': '\u00EA',
    'EighthNote': '\u266A',
    'Element': '\u2208',
    'Ellipsis': '\u2026',
    'EmptyCircle': '\u25CB',
    'EmptyDiamond': '\u25C7',
    'EmptyDownTriangle': '\u25BD',
    'EmptyRectangle': '\u25AF',
    'EmptySet': '\u2205',
    'EmptySmallCircle': '\u25E6',
    'EmptySmallSquare': '\u25FB',
    'EmptySquare': '\u25A1',
    'EmptyUpTriangle': '\u25B3',
    'EmptyVerySmallSquare': '\u25AB',
    'EnterKey': '\uF7D4',
    'EntityEnd': '\uF3B9',
    'EntityStart': '\uF3B8',
    'Epsilon': '\u03F5',
    'Equal': '\uF431',
    'EqualTilde': '\u2242',
    'Equilibrium': '\u21CC',
    'Equivalent': '\u29E6',
    'ErrorIndicator': '\uF767',
    'EscapeKey': '\uF769',
    'Eta': '\u03B7',
    'Eth': '\u00F0',
    'Euro': '\u20AC',
    'Exists': '\u2203',
    'ExponentialE': '\uF74D',
    'FiLigature': '\uFB01',
    'FilledCircle': '\u25CF',
    'FilledDiamond': '\u25C6',
    'FilledDownTriangle': '\u25BC',
    'FilledLeftTriangle': '\u25C0',
    'FilledRectangle': '\u25AE',
    'FilledRightTriangle': '\u25B6',
    'FilledSmallCircle': '\uF750',
    'FilledSmallSquare': '\u25FC',
    'FilledSquare': '\u25A0',
    'FilledUpTriangle': '\u25B2',
    'FilledVerySmallSquare': '\u25AA',
    'FinalSigma': '\u03C2',
    'FirstPage': '\uF7FA',
    'FivePointedStar': '\u2605',
    'Flat': '\u266D',
    'FlLigature': '\uFB02',
    'Florin': '\u0192',
    'ForAll': '\u2200',
    'FormalA': '\uF800',
    'FormalB': '\uF801',
    'FormalC': '\uF802',
    'FormalCapitalA': '\uF81A',
    'FormalCapitalB': '\uF81B',
    'FormalCapitalC': '\uF81C',
    'FormalCapitalD': '\uF81D',
    'FormalCapitalE': '\uF81E',
    'FormalCapitalF': '\uF81F',
    'FormalCapitalG': '\uF820',
    'FormalCapitalH': '\uF821',
    'FormalCapitalI': '\uF822',
    'FormalCapitalJ': '\uF823',
    'FormalCapitalK': '\uF824',
    'FormalCapitalL': '\uF825',
    'FormalCapitalM': '\uF826',
    'FormalCapitalN': '\uF827',
    'FormalCapitalO': '\uF828',
    'FormalCapitalP': '\uF829',
    'FormalCapitalQ': '\uF82A',
    'FormalCapitalR': '\uF82B',
    'FormalCapitalS': '\uF82C',
    'FormalCapitalT': '\uF82D',
    'FormalCapitalU': '\uF82E',
    'FormalCapitalV': '\uF82F',
    'FormalCapitalW': '\uF830',
    'FormalCapitalX': '\uF831',
    'FormalCapitalY': '\uF832',
    'FormalCapitalZ': '\uF833',
    'FormalD': '\uF803',
    'FormalE': '\uF804',
    'FormalF': '\uF805',
    'FormalG': '\uF806',
    'FormalH': '\uF807',
    'FormalI': '\uF808',
    'FormalJ': '\uF809',
    'FormalK': '\uF80A',
    'FormalL': '\uF80B',
    'FormalM': '\uF80C',
    'FormalN': '\uF80D',
    'FormalO': '\uF80E',
    'FormalP': '\uF80F',
    'FormalQ': '\uF810',
    'FormalR': '\uF811',
    'FormalS': '\uF812',
    'FormalT': '\uF813',
    'FormalU': '\uF814',
    'FormalV': '\uF815',
    'FormalW': '\uF816',
    'FormalX': '\uF817',
    'FormalY': '\uF818',
    'FormalZ': '\uF819',
    'FreakedSmiley': '\uF721',
    'Function': '\uF4A1',
    'Gamma': '\u03B3',
    'Gimel': '\u2137',
    'GothicA': '\uF6CC',
    'GothicB': '\uF6CD',
    'GothicC': '\uF6CE',
    'GothicCapitalA': '\uF78A',
    'GothicCapitalB': '\uF78B',
    'GothicCapitalC': '\u212D',
    'GothicCapitalD': '\uF78D',
    'GothicCapitalE': '\uF78E',
    'GothicCapitalF': '\uF78F',
    'GothicCapitalG': '\uF790',
    'GothicCapitalH': '\u210C',
    'GothicCapitalI': '\u2111',
    'GothicCapitalJ': '\uF793',
    'GothicCapitalK': '\uF794',
    'GothicCapitalL': '\uF795',
    'GothicCapitalM': '\uF796',
    'GothicCapitalN': '\uF797',
    'GothicCapitalO': '\uF798',
    'GothicCapitalP': '\uF799',
    'GothicCapitalQ': '\uF79A',
    'GothicCapitalR': '\u211C',
    'GothicCapitalS': '\uF79C',
    'GothicCapitalT': '\uF79D',
    'GothicCapitalU': '\uF79E',
    'GothicCapitalV': '\uF79F',
    'GothicCapitalW': '\uF7A0',
    'GothicCapitalX': '\uF7A1',
    'GothicCapitalY': '\uF7A2',
    'GothicCapitalZ': '\u2128',
    'GothicD': '\uF6CF',
    'GothicE': '\uF6D0',
    'GothicEight': '\uF7ED',
    'GothicF': '\uF6D1',
    'GothicFive': '\uF7EA',
    'GothicFour': '\uF7E9',
    'GothicG': '\uF6D2',
    'GothicH': '\uF6D3',
    'GothicI': '\uF6D4',
    'GothicJ': '\uF6D5',
    'GothicK': '\uF6D6',
    'GothicL': '\uF6D7',
    'GothicM': '\uF6D8',
    'GothicN': '\uF6D9',
    'GothicNine': '\uF7EF',
    'GothicO': '\uF6DA',
    'GothicOne': '\uF7E6',
    'GothicP': '\uF6DB',
    'GothicQ': '\uF6DC',
    'GothicR': '\uF6DD',
    'GothicS': '\uF6DE',
    'GothicSeven': '\uF7EC',
    'GothicSix': '\uF7EB',
    'GothicT': '\uF6DF',
    'GothicThree': '\uF7E8',
    'GothicTwo': '\uF7E7',
    'GothicU': '\uF6E0',
    'GothicV': '\uF6E1',
    'GothicW': '\uF6E2',
    'GothicX': '\uF6E3',
    'GothicY': '\uF6E4',
    'GothicZ': '\uF6E5',
    'GothicZero': '\uF7E5',
    'GrayCircle': '\uF753',
    'GraySquare': '\uF752',
    'GreaterEqualLess': '\u22DB',
    'GreaterEqual': '\u2265',
    'GreaterFullEqual': '\u2267',
    'GreaterGreater': '\u226B',
    'GreaterLess': '\u2277',
    'GreaterSlantEqual': '\u2A7E',
    'GreaterTilde': '\u2273',
    'Hacek': '\u02C7',
    'HappySmiley': '\u263A',
    'HBar': '\u210F',
    'HeartSuit': '\u2661',
    'HermitianConjugate': '\uF3CE',
    'HorizontalLine': '\u2500',
    'HumpDownHump': '\u224E',
    'HumpEqual': '\u224F',
    'Hyphen': '\u2010',
    'IAcute': '\u00ED',
    'ICup': '\u012D',
    'IDoubleDot': '\u00EF',
    'IGrave': '\u00EC',
    'IHat': '\u00EE',
    'ImaginaryI': '\uF74E',
    'ImaginaryJ': '\uF74F',
    'ImplicitPlus': '\uF39E',
    'Implies': '\uF523',
    'Infinity': '\u221E',
    'Integral': '\u222B',
    'Intersection': '\u22C2',
    'InvisibleApplication': '\uF76D',
    'InvisibleComma': '\uF765',
    'InvisiblePostfixScriptBase': '\uF3B4',
    'InvisiblePrefixScriptBase': '\uF3B3',
    'InvisibleSpace': '\uF360',
    'InvisibleTimes': '\u2062',
    'Iota': '\u03B9',
    'Jupiter': '\u2643',
    'Kappa': '\u03BA',
    'KernelIcon': '\uF756',
    'Koppa': '\u03DF',
    'Lambda': '\u03BB',
    'LastPage': '\uF7FB',
    'LeftAngleBracket': '\u2329',
    'LeftArrowBar': '\u21E4',
    'LeftArrow': '\u2190',
    'LeftArrowRightArrow': '\u21C6',
    'LeftBracketingBar': '\uF603',
    'LeftCeiling': '\u2308',
    'LeftDoubleBracket': '\u301A',
    'LeftDoubleBracketingBar': '\uF605',
    'LeftDownTeeVector': '\u2961',
    'LeftDownVectorBar': '\u2959',
    'LeftDownVector': '\u21C3',
    'LeftFloor': '\u230A',
    'LeftGuillemet': '\u00AB',
    'LeftModified': '\uF76B',
    'LeftPointer': '\u25C2',
    'LeftRightArrow': '\u2194',
    'LeftRightVector': '\u294E',
    'LeftSkeleton': '\uF761',
    'LeftTee': '\u22A3',
    'LeftTeeArrow': '\u21A4',
    'LeftTeeVector': '\u295A',
    'LeftTriangle': '\u22B2',
    'LeftTriangleBar': '\u29CF',
    'LeftTriangleEqual': '\u22B4',
    'LeftUpDownVector': '\u2951',
    'LeftUpTeeVector': '\u2960',
    'LeftUpVector': '\u21BF',
    'LeftUpVectorBar': '\u2958',
    'LeftVector': '\u21BC',
    'LeftVectorBar': '\u2952',
    'LessEqual': '\u2264',
    'LessEqualGreater': '\u22DA',
    'LessFullEqual': '\u2266',
    'LessGreater': '\u2276',
    'LessLess': '\u226A',
    'LessSlantEqual': '\u2A7D',
    'LessTilde': '\u2272',
    'LetterSpace': '\uF754',
    'LightBulb': '\uF723',
    'LongDash': '\u2014',
    'LongEqual': '\uF7D9',
    'LongLeftArrow': '\u27F5',
    'LongLeftRightArrow': '\u27F7',
    'LongRightArrow': '\u27F6',
    'LowerLeftArrow': '\u2199',
    'LowerRightArrow': '\u2198',
    'LSlash': '\u0142',
    'Mars': '\u2642',
    'MathematicaIcon': '\uF757',
    'MeasuredAngle': '\u2221',
    'MediumSpace': '\u205F',
    'Mercury': '\u263F',
    'Mho': '\u2127',
    'Micro': '\u00B5',
    'MinusPlus': '\u2213',
    'Mu': '\u03BC',
    'Nand': '\u22BC',
    'Natural': '\u266E',
    'NegativeMediumSpace': '\uF383',
    'NegativeThickSpace': '\uF384',
    'NegativeThinSpace': '\uF382',
    'NegativeVeryThinSpace': '\uF380',
    'Neptune': '\u2646',
    'NestedGreaterGreater': '\u2AA2',
    'NestedLessLess': '\u2AA1',
    'NeutralSmiley': '\uF722',
    'NHacek': '\u0148',
    'NoBreak': '\u2060',
    'NonBreakingSpace': '\u00A0',
    'Nor': '\u22BD',
    'NotCongruent': '\u2262',
    'NotCupCap': '\u226D',
    'NotDoubleVerticalBar': '\u2226',
    'NotElement': '\u2209',
    'NotEqual': '\u2260',
    'NotEqualTilde': '\uF400',
    'NotExists': '\u2204',
    'NotGreater': '\u226F',
    'NotGreaterEqual': '\u2271',
    'NotGreaterFullEqual': '\u2269',
    'NotGreaterGreater': '\uF427',
    'NotGreaterLess': '\u2279',
    'NotGreaterSlantEqual': '\uF429',
    'NotGreaterTilde': '\u2275',
    'NotHumpDownHump': '\uF402',
    'NotHumpEqual': '\uF401',
    'NotLeftTriangle': '\u22EA',
    'NotLeftTriangleBar': '\uF412',
    'NotLeftTriangleEqual': '\u22EC',
    'NotLessEqual': '\u2270',
    'NotLessFullEqual': '\u2268',
    'NotLessGreater': '\u2278',
    'NotLess': '\u226E',
    'NotLessLess': '\uF422',
    'NotLessSlantEqual': '\uF424',
    'NotLessTilde': '\u2274',
    'Not': '\u00AC',
    'NotNestedGreaterGreater': '\uF428',
    'NotNestedLessLess': '\uF423',
    'NotPrecedes': '\u2280',
    'NotPrecedesEqual': '\uF42B',
    'NotPrecedesSlantEqual': '\u22E0',
    'NotPrecedesTilde': '\u22E8',
    'NotReverseElement': '\u220C',
    'NotRightTriangle': '\u22EB',
    'NotRightTriangleBar': '\uF413',
    'NotRightTriangleEqual': '\u22ED',
    'NotSquareSubset': '\uF42E',
    'NotSquareSubsetEqual': '\u22E2',
    'NotSquareSuperset': '\uF42F',
    'NotSquareSupersetEqual': '\u22E3',
    'NotSubset': '\u2284',
    'NotSubsetEqual': '\u2288',
    'NotSucceeds': '\u2281',
    'NotSucceedsEqual': '\uF42D',
    'NotSucceedsSlantEqual': '\u22E1',
    'NotSucceedsTilde': '\u22E9',
    'NotSuperset': '\u2285',
    'NotSupersetEqual': '\u2289',
    'NotTilde': '\u2241',
    'NotTildeEqual': '\u2244',
    'NotTildeFullEqual': '\u2247',
    'NotTildeTilde': '\u2249',
    'NotVerticalBar': '\u2224',
    'NTilde': '\u00F1',
    'Nu': '\u03BD',
    'Null': '\uF3A0',
    'NumberSign': '\uF724',
    'OAcute': '\u00F3',
    'ODoubleAcute': '\u0151',
    'ODoubleDot': '\u00F6',
    'OE': '\u0153',
    'OGrave': '\u00F2',
    'OHat': '\u00F4',
    'Omega': '\u03C9',
    'Omicron': '\u03BF',
    'OpenCurlyDoubleQuote': '\u201C',
    'OpenCurlyQuote': '\u2018',
    'OptionKey': '\uF7D2',
    'Or': '\u2228',
    'OSlash': '\u00F8',
    'OTilde': '\u00F5',
    'OverBrace': '\uFE37',
    'OverBracket': '\u23B4',
    'OverParenthesis': '\uFE35',
    'Paragraph': '\u00B6',
    'PartialD': '\u2202',
    'Phi': '\u03D5',
    'Pi': '\u03C0',
    'Piecewise': '\uF361',
    'Placeholder': '\uF528',
    'PlusMinus': '\u00B1',
    'Pluto': '\u2647',
    'Precedes': '\u227A',
    'PrecedesEqual': '\u2AAF',
    'PrecedesSlantEqual': '\u227C',
    'PrecedesTilde': '\u227E',
    'Prime': '\u2032',
    'Product': '\u220F',
    'Proportion': '\u2237',
    'Proportional': '\u221D',
    'Psi': '\u03C8',
    'QuarterNote': '\u2669',
    'RawAmpersand': '\u0026',
    'RawAt': '\u0040',
    'RawBackquote': '\u0060',
    'RawBackslash': '\u005C',
    'RawColon': '\u003A',
    'RawComma': '\u002C',
    'RawDash': '\u002D',
    'RawDollar': '\u0024',
    'RawDot': '\u002E',
    'RawDoubleQuote': '\u0022',
    'RawEqual': '\u003D',
    'RawEscape': '\u001B',
    'RawExclamation': '\u0021',
    'RawGreater': '\u003E',
    'RawLeftBrace': '\u007B',
    'RawLeftBracket': '\u005B',
    'RawLeftParenthesis': '\u0028',
    'RawLess': '\u003C',
    'RawNumberSign': '\u0023',
    'RawPercent': '\u0025',
    'RawPlus': '\u002B',
    'RawQuestion': '\u003F',
    'RawQuote': '\u0027',
    'RawRightBrace': '\u007D',
    'RawRightBracket': '\u005D',
    'RawRightParenthesis': '\u0029',
    'RawSemicolon': '\u003B',
    'RawSlash': '\u002F',
    'RawSpace': '\u0020',
    'RawStar': '\u002A',
    'RawTab': '\u0009',
    'RawTilde': '\u007E',
    'RawUnderscore': '\u005F',
    'RawVerticalBar': '\u007C',
    'RawWedge': '\u005E',
    'RegisteredTrademark': '\u00AE',
    'ReturnIndicator': '\u21B5',
    'ReturnKey': '\uF766',
    'ReverseDoublePrime': '\u2036',
    'ReverseElement': '\u220B',
    'ReverseEquilibrium': '\u21CB',
    'ReversePrime': '\u2035',
    'ReverseUpEquilibrium': '\u296F',
    'RHacek': '\u0159',
    'Rho': '\u03C1',
    'RightAngle': '\u221F',
    'RightAngleBracket': '\u232A',
    'RightArrow': '\u2192',
    'RightArrowBar': '\u21E5',
    'RightArrowLeftArrow': '\u21C4',
    'RightBracketingBar': '\uF604',
    'RightCeiling': '\u2309',
    'RightDoubleBracket': '\u301B',
    'RightDoubleBracketingBar': '\uF606',
    'RightDownTeeVector': '\u295D',
    'RightDownVector': '\u21C2',
    'RightDownVectorBar': '\u2955',
    'RightFloor': '\u230B',
    'RightGuillemet': '\u00BB',
    'RightModified': '\uF76C',
    'RightPointer': '\u25B8',
    'RightSkeleton': '\uF762',
    'RightTee': '\u22A2',
    'RightTeeArrow': '\u21A6',
    'RightTeeVector': '\u295B',
    'RightTriangle': '\u22B3',
    'RightTriangleBar': '\u29D0',
    'RightTriangleEqual': '\u22B5',
    'RightUpDownVector': '\u294F',
    'RightUpTeeVector': '\u295C',
    'RightUpVector': '\u21BE',
    'RightUpVectorBar': '\u2954',
    'RightVector': '\u21C0',
    'RightVectorBar': '\u2953',
    'RoundImplies': '\u2970',
    'RoundSpaceIndicator': '\uF3B2',
    'Rule': '\uF522',
    'RuleDelayed': '\uF51F',
    'SadSmiley': '\u2639',
    'Sampi': '\u03E0',
    'Saturn': '\u2644',
    'ScriptA': '\uF6B2',
    'ScriptB': '\uF6B3',
    'ScriptC': '\uF6B4',
    'ScriptCapitalA': '\uF770',
    'ScriptCapitalB': '\u212C',
    'ScriptCapitalC': '\uF772',
    'ScriptCapitalD': '\uF773',
    'ScriptCapitalE': '\u2130',
    'ScriptCapitalF': '\u2131',
    'ScriptCapitalG': '\uF776',
    'ScriptCapitalH': '\u210B',
    'ScriptCapitalI': '\u2110',
    'ScriptCapitalJ': '\uF779',
    'ScriptCapitalK': '\uF77A',
    'ScriptCapitalL': '\u2112',
    'ScriptCapitalM': '\u2133',
    'ScriptCapitalN': '\uF77D',
    'ScriptCapitalO': '\uF77E',
    'ScriptCapitalP': '\u2118',
    'ScriptCapitalQ': '\uF780',
    'ScriptCapitalR': '\u211B',
    'ScriptCapitalS': '\uF782',
    'ScriptCapitalT': '\uF783',
    'ScriptCapitalU': '\uF784',
    'ScriptCapitalV': '\uF785',
    'ScriptCapitalW': '\uF786',
    'ScriptCapitalX': '\uF787',
    'ScriptCapitalY': '\uF788',
    'ScriptCapitalZ': '\uF789',
    'ScriptD': '\uF6B5',
    'ScriptDotlessI': '\uF730',
    'ScriptDotlessJ': '\uF731',
    'ScriptE': '\u212F',
    'ScriptEight': '\uF7F8',
    'ScriptF': '\uF6B7',
    'ScriptFive': '\uF7F5',
    'ScriptFour': '\uF7F4',
    'ScriptG': '\u210A',
    'ScriptH': '\uF6B9',
    'ScriptI': '\uF6BA',
    'ScriptJ': '\uF6BB',
    'ScriptK': '\uF6BC',
    'ScriptL': '\u2113',
    'ScriptM': '\uF6BE',
    'ScriptN': '\uF6BF',
    'ScriptNine': '\uF7F9',
    'ScriptO': '\u2134',
    'ScriptOne': '\uF7F1',
    'ScriptP': '\uF6C1',
    'ScriptQ': '\uF6C2',
    'ScriptR': '\uF6C3',
    'ScriptS': '\uF6C4',
    'ScriptSeven': '\uF7F7',
    'ScriptSix': '\uF7F6',
    'ScriptT': '\uF6C5',
    'ScriptThree': '\uF7F3',
    'ScriptTwo': '\uF7F2',
    'ScriptU': '\uF6C6',
    'ScriptV': '\uF6C7',
    'ScriptW': '\uF6C8',
    'ScriptX': '\uF6C9',
    'ScriptY': '\uF6CA',
    'ScriptZ': '\uF6CB',
    'ScriptZero': '\uF7F0',
    'Section': '\u00A7',
    'SelectionPlaceholder': '\uF527',
    'SHacek': '\u0161',
    'Sharp': '\u266F',
    'ShortLeftArrow': '\uF526',
    'ShortRightArrow': '\uF525',
    'Sigma': '\u03C3',
    'SixPointedStar': '\u2736',
    'SkeletonIndicator': '\u2043',
    'SmallCircle': '\u2218',
    'SpaceIndicator': '\u2423',
    'SpaceKey': '\uF7BF',
    'SpadeSuit': '\u2660',
    'SpanFromAbove': '\uF3BB',
    'SpanFromBoth': '\uF3BC',
    'SpanFromLeft': '\uF3BA',
    'SphericalAngle': '\u2222',
    'Sqrt': '\u221A',
    'Square': '\uF520',
    'SquareIntersection': '\u2293',
    'SquareSubset': '\u228F',
    'SquareSubsetEqual': '\u2291',
    'SquareSuperset': '\u2290',
    'SquareSupersetEqual': '\u2292',
    'SquareUnion': '\u2294',
    'Star': '\u22C6',
    'Sterling': '\u00A3',
    'Stigma': '\u03DB',
    'Subset': '\u2282',
    'SubsetEqual': '\u2286',
    'Succeeds': '\u227B',
    'SucceedsEqual': '\u2AB0',
    'SucceedsSlantEqual': '\u227D',
    'SucceedsTilde': '\u227F',
    'SuchThat': '\u220D',
    'Sum': '\u2211',
    'Superset': '\u2283',
    'SupersetEqual': '\u2287',
    'SystemEnterKey': '\uF75F',
    'SZ': '\u00DF',
    'TabKey': '\uF7BE',
    'Tau': '\u03C4',
    'THacek': '\u0165',
    'Therefore': '\u2234',
    'Theta': '\u03B8',
    'ThickSpace': '\u2005',
    'ThinSpace': '\u2009',
    'Thorn': '\u00FE',
    'Tilde': '\u223C',
    'TildeEqual': '\u2243',
    'TildeFullEqual': '\u2245',
    'TildeTilde': '\u2248',
    'Times': '\u00D7',
    'Trademark': '\u2122',
    'Transpose': '\uF3C7',
    'UAcute': '\u00FA',
    'UDoubleAcute': '\u0171',
    'UDoubleDot': '\u00FC',
    'UGrave': '\u00F9',
    'UHat': '\u00FB',
    'UnderBrace': '\uFE38',
    'UnderBracket': '\u23B5',
    'UnderParenthesis': '\uFE36',
    'Union': '\u22C3',
    'UnionPlus': '\u228E',
    'UpArrow': '\u2191',
    'UpArrowBar': '\u2912',
    'UpArrowDownArrow': '\u21C5',
    'UpDownArrow': '\u2195',
    'UpEquilibrium': '\u296E',
    'UpperLeftArrow': '\u2196',
    'UpperRightArrow': '\u2197',
    'UpPointer': '\u25B4',
    'Upsilon': '\u03C5',
    'UpTee': '\u22A5',
    'UpTeeArrow': '\u21A5',
    'Uranus': '\u2645',
    'URing': '\u016F',
    'Vee': '\u22C1',
    'Venus': '\u2640',
    'VerticalBar': '\u2223',
    'VerticalEllipsis': '\u22EE',
    'VerticalLine': '\u2502',
    'VerticalSeparator': '\uF432',
    'VerticalTilde': '\u2240',
    'VeryThinSpace': '\u200A',
    'WarningSign': '\uF725',
    'WatchIcon': '\u231A',
    'Wedge': '\u22C0',
    'WeierstrassP': '\u2118',
    'WhiteBishop': '\u2657',
    'WhiteKing': '\u2654',
    'WhiteKnight': '\u2658',
    'WhitePawn': '\u2659',
    'WhiteQueen': '\u2655',
    'WhiteRook': '\u2656',
    'Wolf': '\uF720',
    'Xi': '\u03BE',
    'Xnor': '\uF4A2',
    'Xor': '\u22BB',
    'YAcute': '\u00FD',
    'YDoubleDot': '\u00FF',
    'Yen': '\u00A5',
    'Zeta': '\u03B6',
    'ZHacek': '\u017E',
}

aliased_characters = {
    "a'": '\u00E1',
    'a-': '\u0101',
    'au': '\u0103',
    'a"': '\u00E4',
    'ae': '\u00E6',
    'a`': '\u00E0',
    'a^': '\u00E2',
    'al': '\u2135',
    'esc': '\uF768',
    'am': '\uF760',
    'a': '\u03B1',
    'alpha': '\u03B1',
    'alt': '\uF7D1',
    '&&': '\u2227',
    'and': '\u2227',
    'Ang': '\u212B',
    'ao': '\u00E5',
    'a~': '\u00E3',
    '\\': '\u2216',
    'be': '\u2136',
    'b': '\u03B2',
    'beta': '\u03B2',
    'bv': '\u02D8',
    'bu': '\u2022',
    "c'": '\u0107',
    "A'": '\u00C1',
    'A-': '\u0100',
    'Au': '\u0102',
    'A"': '\u00C4',
    'AE': '\u00C6',
    'A`': '\u00C0',
    'A^': '\u00C2',
    'A': '\u0391',
    'Alpha': '\u0391',
    'Ao': '\u00C5',
    'A~': '\u00C3',
    'B': '\u0392',
    'Beta': '\u0392',
    "C'": '\u0106',
    'C,': '\u00C7',
    'Cv': '\u010C',
    'Ch': '\u03A7',
    'Chi': '\u03A7',
    'C': '\u03A7',
    'D': '\u0394',
    'Delta': '\u0394',
    'Dv': '\u010E',
    'DD': '\uF74B',
    'Di': '\u03DC',
    'Digamma': '\u03DC',
    "E'": '\u00C9',
    'E-': '\u0112',
    'Eu': '\u0114',
    'E"': '\u00CB',
    'E`': '\u00C8',
    'Ev': '\u011A',
    'E^': '\u00CA',
    'E': '\u0395',
    'Epsilon': '\u0395',
    'Et': '\u0397',
    'Eta': '\u0397',
    'H': '\u0397',
    'D-': '\u00D0',
    'G': '\u0393',
    'Gamma': '\u0393',
    "I'": '\u00CD',
    'Iu': '\u012C',
    'I"': '\u00CF',
    'I`': '\u00CC',
    'I^': '\u00CE',
    'I': '\u0399',
    'Iota': '\u0399',
    'K': '\u039A',
    'Kappa': '\u039A',
    'Ko': '\u03DE',
    'Koppa': '\u03DE',
    'L': '\u039B',
    'Lambda': '\u039B',
    'L/': '\u0141',
    'M': '\u039C',
    'Mu': '\u039C',
    'Nv': '\u0147',
    'N~': '\u00D1',
    'N': '\u039D',
    'Nu': '\u039D',
    "O'": '\u00D3',
    "O''": '\u0150',
    'O"': '\u00D6',
    'OE': '\u0152',
    'O`': '\u00D2',
    'O^': '\u00D4',
    'O': '\u03A9',
    'Omega': '\u03A9',
    'W': '\u03A9',
    'Om': '\u039F',
    'Omicron': '\u039F',
    'O/': '\u00D8',
    'O~': '\u00D5',
    'Ph': '\u03A6',
    'Phi': '\u03A6',
    'F': '\u03A6',
    'P': '\u03A0',
    'Pi': '\u03A0',
    'Ps': '\u03A8',
    'Psi': '\u03A8',
    'Y': '\u03A8',
    'Rv': '\u0158',
    'R': '\u03A1',
    'Rho': '\u03A1',
    'Sa': '\u03E0',
    'Sampi': '\u03E0',
    'Sv': '\u0160',
    'S': '\u03A3',
    'Sigma': '\u03A3',
    'T': '\u03A4',
    'Tau': '\u03A4',
    'Tv': '\u0164',
    'Th': '\u0398',
    'Theta': '\u0398',
    'Q': '\u0398',
    'Thn': '\u00DE',
    "U'": '\u00DA',
    "U''": '\u0170',
    'U"': '\u00DC',
    'U`': '\u00D9',
    'U^': '\u00DB',
    'U': '\u03A5',
    'Upsilon': '\u03A5',
    'Uo': '\u016E',
    'X': '\u039E',
    'Xi': '\u039E',
    "Y'": '\u00DD',
    'Z': '\u0396',
    'Zeta': '\u0396',
    'Zv': '\u017D',
    'c,': '\u00E7',
    'cd': '\u00B8',
    '.': '\u00B7',
    'cent': '\u00A2',
    'cv': '\u010D',
    'ch': '\u03C7',
    'chi': '\u03C7',
    'c': '\u03C7',
    'c.': '\u2299',
    'c-': '\u2296',
    'c+': '\u2295',
    'c*': '\u2297',
    'ccint': '\u2232',
    'cl': '\u2318',
    ':': '\u2236',
    'cmd': '\uF76A',
    '===': '\u2261',
    'co': '\uF3C8',
    'conj': '\uF3C8',
    'ct': '\uF3C9',
    'cont': '\uF3B1',
    'cint': '\u222E',
    'ctrl': '\uF763',
    'coprod': '\u2210',
    'cccint': '\u2233',
    'cross': '\uF4A0',
    'cU': '\u03D2',
    'cUpsilon': '\u03D2',
    'ce': '\u03B5',
    'cepsilon': '\u03B5',
    'ck': '\u03F0',
    'ckappa': '\u03F0',
    'j': '\u03C6',
    'cph': '\u03C6',
    'cphi': '\u03C6',
    'cp': '\u03D6',
    'cpi': '\u03D6',
    'cr': '\u03F1',
    'crho': '\u03F1',
    'cq': '\u03D1',
    'cth': '\u03D1',
    'ctheta': '\u03D1',
    'dg': '\u2020',
    'da': '\u2138',
    '-': '\u2013',
    'deg': '\u00B0',
    ' del': '\uF7D0',
    'del': '\u2207',
    'd': '\u03B4',
    'delta': '\u03B4',
    'dv': '\u010F',
    'dia': '\u22C4',
    'diffd': '\u2206',
    'dd': '\uF74C',
    'di': '\u03DD',
    'digamma': '\u03DD',
    'dratio': '\uF4A4',
    'shift': '\uF4A3',
    'dhy': '\u00AD',
    'dlsep': '\uF76E',
    'dpsep': '\uF76F',
    'div': '\u00F7',
    '.=': '\u2250',
    'ddg': '\u2021',
    'gg': '\uF74A',
    'pp': '\uF749',
    ' <=': '\u21D0',
    '<=>': '\u21D4',
    '<==': '\u27F8',
    '<==>': '\u27FA',
    '==>': '\u27F9',
    "''": '\u2033',
    ' =>': '\u21D2',
    'dsa': '\uF6E6',
    'dsb': '\uF6E7',
    'dsc': '\uF6E8',
    'dsA': '\uF7A4',
    'dsB': '\uF7A5',
    'dsC': '\uF7A6',
    'dsD': '\uF7A7',
    'dsE': '\uF7A8',
    'dsF': '\uF7A9',
    'dsG': '\uF7AA',
    'dsH': '\uF7AB',
    'dsI': '\uF7AC',
    'dsJ': '\uF7AD',
    'dsK': '\uF7AE',
    'dsL': '\uF7AF',
    'dsM': '\uF7B0',
    'dsN': '\uF7B1',
    'dsO': '\uF7B2',
    'dsP': '\uF7B3',
    'dsQ': '\uF7B4',
    'dsR': '\uF7B5',
    'dsS': '\uF7B6',
    'dsT': '\uF7B7',
    'dsU': '\uF7B8',
    'dsV': '\uF7B9',
    'dsW': '\uF7BA',
    'dsX': '\uF7BB',
    'dsY': '\uF7BC',
    'dsZ': '\uF7BD',
    'dsd': '\uF6E9',
    'dse': '\uF6EA',
    'ds8': '\uF7E3',
    'dsf': '\uF6EB',
    'ds5': '\uF7E0',
    'ds4': '\uF7DF',
    'dsg': '\uF6EC',
    'dsh': '\uF6ED',
    'dsi': '\uF6EE',
    'dsj': '\uF6EF',
    'dsk': '\uF6F0',
    'dsl': '\uF6F1',
    'dsm': '\uF6F2',
    'dsn': '\uF6F3',
    'ds9': '\uF7E4',
    'dso': '\uF6F4',
    'ds1': '\uF7DC',
    'dsp': '\uF6F5',
    'dsq': '\uF6F6',
    'dsr': '\uF6F7',
    'dss': '\uF6F8',
    'ds7': '\uF7E2',
    'ds6': '\uF7E1',
    'dst': '\uF6F9',
    'ds3': '\uF7DE',
    'ds2': '\uF7DD',
    'dsu': '\uF6FA',
    'dsv': '\uF6FB',
    'dsw': '\uF6FC',
    'dsx': '\uF6FD',
    'dsy': '\uF6FE',
    'dsz': '\uF6FF',
    'ds0': '\uF7DB',
    ' ||': '\u2225',
    'dbv': '\uF755',
    'd!': '\u00A1',
    'd?': '\u00BF',
    'dT': '\u22A4',
    "e'": '\u00E9',
    'e-': '\u0113',
    'eu': '\u0115',
    'e"': '\u00EB',
    'e`': '\u00E8',
    'ev': '\u011B',
    'e^': '\u00EA',
    'el': '\u2208',
    'elem': '\u2208',
    '...': '\u2026',
    'eci': '\u25CB',
    'es': '\u2205',
    'esci': '\u25E6',
    'essq': '\u25FB',
    'esq': '\u25A1',
    'ent': '\uF7D4',
    'e': '\u03F5',
    'epsilon': '\u03F5',
    '==': '\uF431',
    '=~': '\u2242',
    'equi': '\u21CC',
    'equiv': '\u29E6',
    ' esc': '\uF769',
    'et': '\u03B7',
    'eta': '\u03B7',
    'h': '\u03B7',
    'd-': '\u00F0',
    'ex': '\u2203',
    'ee': '\uF74D',
    'fci': '\u25CF',
    'fsci': '\uF750',
    'fssq': '\u25FC',
    'fsq': '\u25A0',
    'fvssq': '\u25AA',
    'fs': '\u03C2',
    '*5': '\u2605',
    'fa': '\u2200',
    '$a': '\uF800',
    '$b': '\uF801',
    '$c': '\uF802',
    '$A': '\uF81A',
    '$B': '\uF81B',
    '$C': '\uF81C',
    '$D': '\uF81D',
    '$E': '\uF81E',
    '$F': '\uF81F',
    '$G': '\uF820',
    '$H': '\uF821',
    '$I': '\uF822',
    '$J': '\uF823',
    '$K': '\uF824',
    '$L': '\uF825',
    '$M': '\uF826',
    '$N': '\uF827',
    '$O': '\uF828',
    '$P': '\uF829',
    '$Q': '\uF82A',
    '$R': '\uF82B',
    '$S': '\uF82C',
    '$T': '\uF82D',
    '$U': '\uF82E',
    '$V': '\uF82F',
    '$W': '\uF830',
    '$X': '\uF831',
    '$Y': '\uF832',
    '$Z': '\uF833',
    '$d': '\uF803',
    '$e': '\uF804',
    '$f': '\uF805',
    '$g': '\uF806',
    '$h': '\uF807',
    '$i': '\uF808',
    '$j': '\uF809',
    '$k': '\uF80A',
    '$l': '\uF80B',
    '$m': '\uF80C',
    '$n': '\uF80D',
    '$o': '\uF80E',
    '$p': '\uF80F',
    '$q': '\uF810',
    '$r': '\uF811',
    '$s': '\uF812',
    '$t': '\uF813',
    '$u': '\uF814',
    '$v': '\uF815',
    '$w': '\uF816',
    '$x': '\uF817',
    '$y': '\uF818',
    '$z': '\uF819',
    ':-@': '\uF721',
    'fn': '\uF4A1',
    'g': '\u03B3',
    'gamma': '\u03B3',
    'gi': '\u2137',
    'goa': '\uF6CC',
    'gob': '\uF6CD',
    'goc': '\uF6CE',
    'goA': '\uF78A',
    'goB': '\uF78B',
    'goC': '\u212D',
    'goD': '\uF78D',
    'goE': '\uF78E',
    'goF': '\uF78F',
    'goG': '\uF790',
    'goH': '\u210C',
    'goI': '\u2111',
    'goJ': '\uF793',
    'goK': '\uF794',
    'goL': '\uF795',
    'goM': '\uF796',
    'goN': '\uF797',
    'goO': '\uF798',
    'goP': '\uF799',
    'goQ': '\uF79A',
    'goR': '\u211C',
    'goS': '\uF79C',
    'goT': '\uF79D',
    'goU': '\uF79E',
    'goV': '\uF79F',
    'goW': '\uF7A0',
    'goX': '\uF7A1',
    'goY': '\uF7A2',
    'goZ': '\u2128',
    'god': '\uF6CF',
    'goe': '\uF6D0',
    'go8': '\uF7ED',
    'gof': '\uF6D1',
    'go5': '\uF7EA',
    'go4': '\uF7E9',
    'gog': '\uF6D2',
    'goh': '\uF6D3',
    'goi': '\uF6D4',
    'goj': '\uF6D5',
    'gok': '\uF6D6',
    'gol': '\uF6D7',
    'gom': '\uF6D8',
    'gon': '\uF6D9',
    'go9': '\uF7EF',
    'goo': '\uF6DA',
    'go1': '\uF7E6',
    'gop': '\uF6DB',
    'goq': '\uF6DC',
    'gor': '\uF6DD',
    'gos': '\uF6DE',
    'go7': '\uF7EC',
    'go6': '\uF7EB',
    'got': '\uF6DF',
    'go3': '\uF7E8',
    'go2': '\uF7E7',
    'gou': '\uF6E0',
    'gov': '\uF6E1',
    'gow': '\uF6E2',
    'gox': '\uF6E3',
    'goy': '\uF6E4',
    'goz': '\uF6E5',
    'go0': '\uF7E5',
    'gci': '\uF753',
    'gsq': '\uF752',
    '>=': '\u2265',
    '>/': '\u2A7E',
    '>~': '\u2273',
    'hck': '\u02C7',
    ':)': '\u263A',
    ':-)': '\u263A',
    'hb': '\u210F',
    'hc': '\uF3CE',
    'hline': '\u2500',
    'h=': '\u224F',
    "i'": '\u00ED',
    'iu': '\u012D',
    'i"': '\u00EF',
    'i`': '\u00EC',
    'i^': '\u00EE',
    'ii': '\uF74E',
    'jj': '\uF74F',
    '+': '\uF39E',
    '=>': '\uF523',
    'inf': '\u221E',
    'int': '\u222B',
    'inter': '\u22C2',
    '@': '\uF76D',
    ',': '\uF765',
    'is': '\uF360',
    'i': '\u03B9',
    'iota': '\u03B9',
    'k': '\u03BA',
    'kappa': '\u03BA',
    'ko': '\u03DF',
    'koppa': '\u03DF',
    'l': '\u03BB',
    'lambda': '\u03BB',
    '<': '\u2329',
    '<-': '\u2190',
    'l|': '\uF603',
    'lc': '\u2308',
    '[[': '\u301A',
    'l||': '\uF605',
    'lf': '\u230A',
    'g<<': '\u00AB',
    '[': '\uF76B',
    '<->': '\u2194',
    'lT': '\u22A3',
    '<=': '\u2264',
    '</': '\u2A7D',
    '<~': '\u2272',
    '_': '\uF754',
    'ls': '\uF754',
    '--': '\u2014',
    '<--': '\u27F5',
    '<-->': '\u27F7',
    '-->': '\u27F6',
    'l/': '\u0142',
    'math': '\uF757',
    '   ': '\u205F',
    'mho': '\u2127',
    'mi': '\u00B5',
    '-+': '\u2213',
    'm': '\u03BC',
    'mu': '\u03BC',
    'nand': '\u22BC',
    '-   ': '\uF383',
    '-    ': '\uF384',
    '-  ': '\uF382',
    '- ': '\uF380',
    ':-|': '\uF722',
    'nv': '\u0148',
    'nb': '\u2060',
    'nbs': '\u00A0',
    'nor': '\u22BD',
    '!===': '\u2262',
    '!||': '\u2226',
    '!el': '\u2209',
    '!elem': '\u2209',
    '!=': '\u2260',
    '!=~': '\uF400',
    '!ex': '\u2204',
    '!>': '\u226F',
    '!>=': '\u2271',
    '!>/': '\uF429',
    '!>~': '\u2275',
    '!h=': '\uF401',
    '!<=': '\u2270',
    '!<': '\u226E',
    '!</': '\uF424',
    '!<~': '\u2274',
    '!': '\u00AC',
    'not': '\u00AC',
    '!mem': '\u220C',
    '!sub': '\u2284',
    '!sub=': '\u2288',
    '!sup': '\u2285',
    '!sup=': '\u2289',
    '!~': '\u2241',
    '!~=': '\u2244',
    '!~==': '\u2247',
    '!~~': '\u2249',
    '!|': '\u2224',
    'n~': '\u00F1',
    'n': '\u03BD',
    'nu': '\u03BD',
    'null': '\uF3A0',
    "o'": '\u00F3',
    "o''": '\u0151',
    'o"': '\u00F6',
    'oe': '\u0153',
    'o`': '\u00F2',
    'o^': '\u00F4',
    'o': '\u03C9',
    'omega': '\u03C9',
    'w': '\u03C9',
    'om': '\u03BF',
    'omicron': '\u03BF',
    'opt': '\uF7D2',
    '||': '\u2228',
    'or': '\u2228',
    'o/': '\u00F8',
    'o~': '\u00F5',
    'o{': '\uFE37',
    'o[': '\u23B4',
    'o(': '\uFE35',
    'pd': '\u2202',
    'ph': '\u03D5',
    'phi': '\u03D5',
    'f': '\u03D5',
    'p': '\u03C0',
    'pi': '\u03C0',
    'pw': '\uF361',
    'pl': '\uF528',
    '+-': '\u00B1',
    "'": '\u2032',
    'prod': '\u220F',
    'prop': '\u221D',
    'ps': '\u03C8',
    'psi': '\u03C8',
    'y': '\u03C8',
    'rtm': '\u00AE',
    'ret': '\u21B5',
    ' ret': '\uF766',
    '``': '\u2036',
    'mem': '\u220B',
    '`': '\u2035',
    'rv': '\u0159',
    'r': '\u03C1',
    'rho': '\u03C1',
    '>': '\u232A',
    ' ->': '\u2192',
    'r|': '\uF604',
    'rc': '\u2309',
    ']]': '\u301B',
    'r||': '\uF606',
    'rf': '\u230B',
    'g>>': '\u00BB',
    ']': '\uF76C',
    'rT': '\u22A2',
    'vec': '\u21C0',
    '->': '\uF522',
    ':>': '\uF51F',
    ':-(': '\u2639',
    'sa': '\u03E0',
    'sampi': '\u03E0',
    'sca': '\uF6B2',
    'scb': '\uF6B3',
    'scc': '\uF6B4',
    'scA': '\uF770',
    'scB': '\u212C',
    'scC': '\uF772',
    'scD': '\uF773',
    'scE': '\u2130',
    'scF': '\u2131',
    'scG': '\uF776',
    'scH': '\u210B',
    'scI': '\u2110',
    'scJ': '\uF779',
    'scK': '\uF77A',
    'scL': '\u2112',
    'scM': '\u2133',
    'scN': '\uF77D',
    'scO': '\uF77E',
    'scP': '\u2118',
    'scQ': '\uF780',
    'scR': '\u211B',
    'scS': '\uF782',
    'scT': '\uF783',
    'scU': '\uF784',
    'scV': '\uF785',
    'scW': '\uF786',
    'scX': '\uF787',
    'scY': '\uF788',
    'scZ': '\uF789',
    'scd': '\uF6B5',
    'sce': '\u212F',
    'sc8': '\uF7F8',
    'scf': '\uF6B7',
    'sc5': '\uF7F5',
    'sc4': '\uF7F4',
    'scg': '\u210A',
    'sch': '\uF6B9',
    'sci': '\uF6BA',
    'scj': '\uF6BB',
    'sck': '\uF6BC',
    'scl': '\u2113',
    'scm': '\uF6BE',
    'scn': '\uF6BF',
    'sc9': '\uF7F9',
    'sco': '\u2134',
    'sc1': '\uF7F1',
    'scp': '\uF6C1',
    'scq': '\uF6C2',
    'scr': '\uF6C3',
    'scs': '\uF6C4',
    'sc7': '\uF7F7',
    'sc6': '\uF7F6',
    'sct': '\uF6C5',
    'sc3': '\uF7F3',
    'sc2': '\uF7F2',
    'scu': '\uF6C6',
    'scv': '\uF6C7',
    'scw': '\uF6C8',
    'scx': '\uF6C9',
    'scy': '\uF6CA',
    'scz': '\uF6CB',
    'sc0': '\uF7F0',
    'spl': '\uF527',
    'sv': '\u0161',
    's': '\u03C3',
    'sigma': '\u03C3',
    '*6': '\u2736',
    'sc': '\u2218',
    'space': '\u2423',
    'spc': '\uF7BF',
    'sqrt': '\u221A',
    'sq': '\uF520',
    'star': '\u22C6',
    'sti': '\u03DB',
    'stigma': '\u03DB',
    'sub': '\u2282',
    'sub=': '\u2286',
    'st': '\u220D',
    'sum': '\u2211',
    'sup': '\u2283',
    'sup=': '\u2287',
    'sz': '\u00DF',
    'ss': '\u00DF',
    'tab': '\uF7BE',
    't': '\u03C4',
    'tau': '\u03C4',
    'tv': '\u0165',
    'tf': '\u2234',
    'th': '\u03B8',
    'theta': '\u03B8',
    'q': '\u03B8',
    '    ': '\u2005',
    '  ': '\u2009',
    'thn': '\u00FE',
    '~': '\u223C',
    '~=': '\u2243',
    '~==': '\u2245',
    '~~': '\u2248',
    '*': '\u00D7',
    'tm': '\u2122',
    'tr': '\uF3C7',
    "u'": '\u00FA',
    "u''": '\u0171',
    'u"': '\u00FC',
    'u`': '\u00F9',
    'u^': '\u00FB',
    'u{': '\uFE38',
    'u[': '\u23B5',
    'u(': '\uFE36',
    'un': '\u22C3',
    'u': '\u03C5',
    'upsilon': '\u03C5',
    'uT': '\u22A5',
    'uo': '\u016F',
    'v': '\u22C1',
    ' |': '\u2223',
    'vline': '\u2502',
    '|': '\uF432',
    ' ': '\u200A',
    '^': '\u22C0',
    'wp': '\u2118',
    'wf': '\uF720',
    'wolf': '\uF720',
    'x': '\u03BE',
    'xi': '\u03BE',
    'xnor': '\uF4A2',
    'xor': '\u22BB',
    "y'": '\u00FD',
    'z': '\u03B6',
    'zeta': '\u03B6',
    'zv': '\u017E',
}
